/*
 * Decompiled with CFR 0.152.
 */
package com.fzzixun.openapi.sdk.sign;

import com.fzzixun.openapi.sdk.sign.SopSignException;
import com.fzzixun.openapi.sdk.sign.StreamUtil;
import com.fzzixun.openapi.sdk.sign.StringUtils;
import com.fzzixun.openapi.sdk.util.Base64Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Cipher;

public class SopSignature {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    public static final String SIGN_TYPE_RSA = "RSA";
    public static final String SIGN_TYPE_RSA2 = "RSA2";
    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    public static final String SIGN_SHA256RSA_ALGORITHMS = "SHA256WithRSA";
    public static final String CHARSET_GBK = "GBK";

    public static String getSignContent(Map<String, ?> sortedParams) {
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String value;
            String key = (String)keys.get(i);
            if (!StringUtils.areNotEmpty(key, value = String.valueOf(sortedParams.get(key)))) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        return content.toString();
    }

    public static String rsaSign(String content, String privateKey, String charset, String signType) throws SopSignException {
        if (SIGN_TYPE_RSA.equals(signType)) {
            return SopSignature.rsaSign(content, privateKey, charset);
        }
        if (SIGN_TYPE_RSA2.equals(signType)) {
            return SopSignature.rsa256Sign(content, privateKey, charset);
        }
        throw new SopSignException("Sign Type is Not Support : signType=" + signType);
    }

    public static String rsa256Sign(String content, String privateKey, String charset) throws SopSignException {
        try {
            PrivateKey priKey = SopSignature.getPrivateKeyFromPKCS8(SIGN_TYPE_RSA, new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_SHA256RSA_ALGORITHMS);
            signature.initSign(priKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return new String(Base64Util.encodeBase64(signed));
        }
        catch (Exception e) {
            throw new SopSignException("RSAcontent = " + content + "; charset = " + charset, e);
        }
    }

    public static String rsaSign(String content, String privateKey, String charset) throws SopSignException {
        try {
            PrivateKey priKey = SopSignature.getPrivateKeyFromPKCS8(SIGN_TYPE_RSA, new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return new String(Base64Util.encodeBase64(signed));
        }
        catch (InvalidKeySpecException ie) {
            throw new SopSignException("RSA\u79c1\u94a5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u914d\u7f6e\u4e86PKCS8\u683c\u5f0f\u7684\u79c1\u94a5", ie);
        }
        catch (Exception e) {
            throw new SopSignException("RSAcontent = " + content + "; charset = " + charset, e);
        }
    }

    public static String rsaSign(Map<String, String> params, String privateKey, String charset) throws SopSignException {
        String signContent = SopSignature.getSignContent(params);
        return SopSignature.rsaSign(signContent, privateKey, charset);
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins == null || StringUtils.isEmpty(algorithm)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = StreamUtil.readText(ins).getBytes();
        encodedKey = Base64Util.decodeBase64(encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static String getSignCheckContentV1(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        params.remove("sign_type");
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append((i == 0 ? "" : "&") + key + "=" + value);
        }
        return content.toString();
    }

    public static String getSignCheckContentV2(Map<String, ?> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = String.valueOf(params.get(key));
            content.append((i == 0 ? "" : "&") + key + "=" + value);
        }
        return content.toString();
    }

    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset) throws SopSignException {
        String sign = params.get("sign");
        String content = SopSignature.getSignCheckContentV1(params);
        return SopSignature.rsaCheckContent(content, sign, publicKey, charset);
    }

    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset, String signType) throws SopSignException {
        String sign = params.get("sign");
        String content = SopSignature.getSignCheckContentV1(params);
        return SopSignature.rsaCheck(content, sign, publicKey, charset, signType);
    }

    public static boolean rsaCheckV2(Map<String, String> params, String publicKey, String charset) throws SopSignException {
        String sign = params.get("sign");
        String content = SopSignature.getSignCheckContentV2(params);
        return SopSignature.rsaCheckContent(content, sign, publicKey, charset);
    }

    public static boolean rsaCheckV2(Map<String, ?> params, String publicKey, String charset, String signType) throws SopSignException {
        String sign = String.valueOf(params.get("sign"));
        String content = SopSignature.getSignCheckContentV2(params);
        return SopSignature.rsaCheck(content, sign, publicKey, charset, signType);
    }

    public static boolean rsaCheck(String content, String sign, String publicKey, String charset, String signType) throws SopSignException {
        if (SIGN_TYPE_RSA.equals(signType)) {
            return SopSignature.rsaCheckContent(content, sign, publicKey, charset);
        }
        if (SIGN_TYPE_RSA2.equals(signType)) {
            return SopSignature.rsa256CheckContent(content, sign, publicKey, charset);
        }
        throw new SopSignException("Sign Type is Not Support : signType=" + signType);
    }

    public static boolean rsa256CheckContent(String content, String sign, String publicKey, String charset) throws SopSignException {
        try {
            PublicKey pubKey = SopSignature.getPublicKeyFromX509(SIGN_TYPE_RSA, new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_SHA256RSA_ALGORITHMS);
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64Util.decodeBase64(sign.getBytes()));
        }
        catch (Exception e) {
            throw new SopSignException("RSAcontent = " + content + ",sign=" + sign + ",charset = " + charset, e);
        }
    }

    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) throws SopSignException {
        try {
            PublicKey pubKey = SopSignature.getPublicKeyFromX509(SIGN_TYPE_RSA, new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64Util.decodeBase64(sign.getBytes()));
        }
        catch (Exception e) {
            throw new SopSignException("RSAcontent = " + content + ",sign=" + sign + ",charset = " + charset, e);
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64Util.decodeBase64(encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    public static String checkSignAndDecrypt(Map<String, String> params, String alipayPublicKey, String cusPrivateKey, boolean isCheckSign, boolean isDecrypt) throws SopSignException {
        String charset = params.get("charset");
        String bizContent = params.get("biz_content");
        if (isCheckSign && !SopSignature.rsaCheckV2(params, alipayPublicKey, charset)) {
            throw new SopSignException("rsaCheck failure:rsaParams=" + params);
        }
        if (isDecrypt) {
            return SopSignature.rsaDecrypt(bizContent, cusPrivateKey, charset);
        }
        return bizContent;
    }

    public static String checkSignAndDecrypt(Map<String, String> params, String alipayPublicKey, String cusPrivateKey, boolean isCheckSign, boolean isDecrypt, String signType) throws SopSignException {
        String charset = params.get("charset");
        String bizContent = params.get("biz_content");
        if (isCheckSign && !SopSignature.rsaCheckV2(params, alipayPublicKey, charset, signType)) {
            throw new SopSignException("rsaCheck failure:rsaParams=" + params);
        }
        if (isDecrypt) {
            return SopSignature.rsaDecrypt(bizContent, cusPrivateKey, charset);
        }
        return bizContent;
    }

    public static String encryptAndSign(String bizContent, String alipayPublicKey, String cusPrivateKey, String charset, boolean isEncrypt, boolean isSign) throws SopSignException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(charset)) {
            charset = CHARSET_GBK;
        }
        sb.append("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
        if (isEncrypt) {
            sb.append("<alipay>");
            String encrypted = SopSignature.rsaEncrypt(bizContent, alipayPublicKey, charset);
            sb.append("<response>" + encrypted + "</response>");
            sb.append("<encryption_type>RSA</encryption_type>");
            if (isSign) {
                String sign = SopSignature.rsaSign(encrypted, cusPrivateKey, charset);
                sb.append("<sign>" + sign + "</sign>");
                sb.append("<sign_type>RSA</sign_type>");
            }
            sb.append("</alipay>");
        } else if (isSign) {
            sb.append("<alipay>");
            sb.append("<response>" + bizContent + "</response>");
            String sign = SopSignature.rsaSign(bizContent, cusPrivateKey, charset);
            sb.append("<sign>" + sign + "</sign>");
            sb.append("<sign_type>RSA</sign_type>");
            sb.append("</alipay>");
        } else {
            sb.append(bizContent);
        }
        return sb.toString();
    }

    public static String encryptAndSign(String bizContent, String alipayPublicKey, String cusPrivateKey, String charset, boolean isEncrypt, boolean isSign, String signType) throws SopSignException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(charset)) {
            charset = CHARSET_GBK;
        }
        sb.append("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
        if (isEncrypt) {
            sb.append("<alipay>");
            String encrypted = SopSignature.rsaEncrypt(bizContent, alipayPublicKey, charset);
            sb.append("<response>" + encrypted + "</response>");
            sb.append("<encryption_type>RSA</encryption_type>");
            if (isSign) {
                String sign = SopSignature.rsaSign(encrypted, cusPrivateKey, charset, signType);
                sb.append("<sign>" + sign + "</sign>");
                sb.append("<sign_type>");
                sb.append(signType);
                sb.append("</sign_type>");
            }
            sb.append("</alipay>");
        } else if (isSign) {
            sb.append("<alipay>");
            sb.append("<response>" + bizContent + "</response>");
            String sign = SopSignature.rsaSign(bizContent, cusPrivateKey, charset, signType);
            sb.append("<sign>" + sign + "</sign>");
            sb.append("<sign_type>");
            sb.append(signType);
            sb.append("</sign_type>");
            sb.append("</alipay>");
        } else {
            sb.append(bizContent);
        }
        return sb.toString();
    }

    public static String rsaEncrypt(String content, String publicKey, String charset) throws SopSignException {
        try {
            PublicKey pubKey = SopSignature.getPublicKeyFromX509(SIGN_TYPE_RSA, new ByteArrayInputStream(publicKey.getBytes()));
            Cipher cipher = Cipher.getInstance(SIGN_TYPE_RSA);
            cipher.init(1, pubKey);
            byte[] data = StringUtils.isEmpty(charset) ? content.getBytes() : content.getBytes(charset);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = Base64Util.encodeBase64(out.toByteArray());
            out.close();
            return StringUtils.isEmpty(charset) ? new String(encryptedData) : new String(encryptedData, charset);
        }
        catch (Exception e) {
            throw new SopSignException("EncryptContent = " + content + ",charset = " + charset, e);
        }
    }

    public static String rsaDecrypt(String content, String privateKey, String charset) throws SopSignException {
        try {
            PrivateKey priKey = SopSignature.getPrivateKeyFromPKCS8(SIGN_TYPE_RSA, new ByteArrayInputStream(privateKey.getBytes()));
            Cipher cipher = Cipher.getInstance(SIGN_TYPE_RSA);
            cipher.init(2, priKey);
            byte[] encryptedData = StringUtils.isEmpty(charset) ? Base64Util.decodeBase64(content.getBytes()) : Base64Util.decodeBase64(content.getBytes(charset));
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return StringUtils.isEmpty(charset) ? new String(decryptedData) : new String(decryptedData, charset);
        }
        catch (Exception e) {
            throw new SopSignException("EncodeContent = " + content + ",charset = " + charset, e);
        }
    }
}

