/*
 * Decompiled with CFR 0.152.
 */
package com.fzzixun.openapi.sdk.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fzzixun.openapi.sdk.client.OpenRequest;
import com.fzzixun.openapi.sdk.common.DataNameBuilder;
import com.fzzixun.openapi.sdk.common.OpenConfig;
import com.fzzixun.openapi.sdk.common.RequestForm;
import com.fzzixun.openapi.sdk.common.SopSdkConstants;
import com.fzzixun.openapi.sdk.common.SopSdkErrors;
import com.fzzixun.openapi.sdk.request.BaseRequest;
import com.fzzixun.openapi.sdk.response.BaseResponse;
import com.fzzixun.openapi.sdk.response.ErrorResponse;
import com.fzzixun.openapi.sdk.sign.SopSignException;
import com.fzzixun.openapi.sdk.sign.SopSignature;
import com.fzzixun.openapi.sdk.sign.StringUtils;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenClient {
    private static final Log log = LogFactory.getLog(OpenClient.class);
    private static final String USER_ASSESS_TOKEN = "user_access_token";
    private static final String APP_AUTH_TOKEN = "app_auth_token";
    private static final OpenConfig DEFAULT_CONFIG = new OpenConfig();
    private final String url;
    private final String appId;
    private final String privateKey;
    private String publicKeyPlatform;
    private final OpenConfig openConfig;
    private final OpenRequest openRequest;
    private final DataNameBuilder dataNameBuilder;

    public OpenClient(String url, String appId, String privateKeyIsv) {
        this(url, appId, privateKeyIsv, DEFAULT_CONFIG);
    }

    public OpenClient(String url, String appId, String privateKeyIsv, String publicKeyPlatform) {
        this(url, appId, privateKeyIsv);
        this.publicKeyPlatform = publicKeyPlatform;
    }

    public OpenClient(String url, String appId, String privateKeyIsv, OpenConfig openConfig) {
        if (openConfig == null) {
            throw new IllegalArgumentException("openConfig\u4e0d\u80fd\u4e3anull");
        }
        this.url = url;
        this.appId = appId;
        this.privateKey = privateKeyIsv;
        this.openConfig = openConfig;
        this.openRequest = new OpenRequest(openConfig);
        this.dataNameBuilder = openConfig.getDataNameBuilder();
    }

    public OpenClient(String url, String appId, String privateKeyIsv, String publicKeyPlatform, OpenConfig openConfig) {
        this(url, appId, privateKeyIsv, openConfig);
        this.publicKeyPlatform = publicKeyPlatform;
    }

    public <T extends BaseResponse> T execute(BaseRequest<T> request) {
        return this.execute(request, null);
    }

    public <T extends BaseResponse> T executeUserToken(BaseRequest<T> request, String userToken) {
        RequestForm requestForm = request.createRequestForm(this.openConfig);
        Map<String, String> form = requestForm.getForm();
        form.put(USER_ASSESS_TOKEN, userToken);
        return this.execute(request, requestForm, form);
    }

    public <T extends BaseResponse> T executeAppToken(BaseRequest<T> request, String appToken) {
        RequestForm requestForm = request.createRequestForm(this.openConfig);
        Map<String, String> form = requestForm.getForm();
        form.put(APP_AUTH_TOKEN, appToken);
        return this.execute(request, requestForm, form);
    }

    public <T extends BaseResponse> T execute(BaseRequest<T> request, Map<String, String> tokenParam) {
        RequestForm requestForm = request.createRequestForm(this.openConfig);
        Map<String, String> form = requestForm.getForm();
        if (tokenParam != null) {
            tokenParam.forEach((k, v) -> form.put((String)k, (String)v));
        }
        return this.execute(request, requestForm, form);
    }

    private <T extends BaseResponse> T execute(BaseRequest<T> request, RequestForm requestForm, Map<String, String> form) {
        form.put(this.openConfig.getAppKeyName(), this.appId);
        String content = SopSignature.getSignContent(form);
        String sign = null;
        try {
            sign = SopSignature.rsaSign(content, this.privateKey, this.openConfig.getCharset(), this.openConfig.getSignType());
        }
        catch (SopSignException e) {
            String resp = "{\n    \"sub_code\": \"isv.common-error\",\n    \"sub_msg\": \"\u6784\u5efa\u7b7e\u540d\u9519\u8bef\"\n}";
            JSONObject jsonObject = JSON.parseObject((String)resp, (Feature[])new Feature[]{Feature.OrderedField});
            BaseResponse t = (BaseResponse)jsonObject.toJavaObject(request.getResponseClass());
            t.setBody(jsonObject.toJSONString());
            return (T)t;
        }
        form.put(this.openConfig.getSignName(), sign);
        String resp = this.doExecute(this.url, requestForm, Collections.emptyMap());
        if (log.isDebugEnabled()) {
            log.debug((Object)("----------- \u8bf7\u6c42\u4fe1\u606f -----------\n\u8bf7\u6c42\u53c2\u6570\uff1a" + SopSignature.getSignContent(form) + "\n\u5f85\u7b7e\u540d\u5185\u5bb9\uff1a" + content + "\n\u7b7e\u540d(sign)\uff1a" + sign + "\n----------- \u8fd4\u56de\u7ed3\u679c -----------\n" + resp));
        }
        return this.parseResponse(resp, request);
    }

    protected String doExecute(String url, RequestForm requestForm, Map<String, String> header) {
        return this.openRequest.request(url, requestForm, header);
    }

    protected <T extends BaseResponse> T parseResponse(String resp, BaseRequest<T> request) {
        String signContent;
        String sign;
        String errorResponseName;
        String method = request.getMethod();
        String rootNodeName = this.dataNameBuilder.build(method);
        JSONObject jsonObject = JSON.parseObject((String)resp, (Feature[])new Feature[]{Feature.OrderedField});
        boolean errorResponse = jsonObject.containsKey((Object)(errorResponseName = this.openConfig.getErrorResponseName()));
        if (errorResponse) {
            rootNodeName = errorResponseName;
        }
        if (StringUtils.areNotEmpty(sign = jsonObject.getString(this.openConfig.getSignName()), this.publicKeyPlatform) && !this.checkResponseSign(signContent = this.buildBizJson(rootNodeName, resp), sign, this.publicKeyPlatform)) {
            ErrorResponse error = SopSdkErrors.CHECK_RESPONSE_SIGN_ERROR.getErrorResponse();
            jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)error));
        }
        BaseResponse t = (BaseResponse)jsonObject.toJavaObject(request.getResponseClass());
        t.setBody(jsonObject.toJSONString());
        return (T)t;
    }

    protected String buildBizJson(String rootNodeName, String body) {
        int indexOfRootNode = body.indexOf(rootNodeName);
        if (indexOfRootNode < 0) {
            rootNodeName = SopSdkConstants.ERROR_RESPONSE_KEY;
            indexOfRootNode = body.indexOf(rootNodeName);
        }
        String result = null;
        if (indexOfRootNode > 0) {
            result = this.buildJsonNodeData(body, rootNodeName, indexOfRootNode);
        }
        return result;
    }

    protected String buildJsonNodeData(String body, String rootNodeName, int indexOfRootNode) {
        int signDataStartIndex = indexOfRootNode + rootNodeName.length() + 2;
        int indexOfSign = body.indexOf("\"" + this.openConfig.getSignName() + "\"");
        if (indexOfSign < 0) {
            return null;
        }
        int length = indexOfSign - 1;
        return body.substring(signDataStartIndex, length);
    }

    protected boolean checkResponseSign(String signContent, String sign, String publicKeyPlatform) {
        try {
            String charset = this.openConfig.getCharset();
            String signType = this.openConfig.getSignType();
            return SopSignature.rsaCheck(signContent, sign, publicKeyPlatform, charset, signType);
        }
        catch (SopSignException e) {
            log.error((Object)("\u9a8c\u8bc1\u670d\u52a1\u7aefsign\u51fa\u9519\uff0csignContent\uff1a" + signContent), (Throwable)e);
            return false;
        }
    }
}

