```java
package com.fzzixun.openapi.sdk.demo;

import com.fzzixun.openapi.sdk.client.OpenClient;
import com.fzzixun.openapi.sdk.model.*;
import com.fzzixun.openapi.sdk.request.*;
import com.fzzixun.openapi.sdk.response.*;
import org.junit.Test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


public class OpenApiDemo {

    private static final String url = "https://sbappstoreapi.ziniao.com";

    /**
     * 应用id
     */
    private static final String appId = "填写应用id";

    /**
     * 应用私钥
     */
    private static final String privateKeyIsv = "填写应用私钥";

    // 声明一个就行
    private static final OpenClient client = new OpenClient(url, appId, privateKeyIsv);

    private final String userToken = "fb4eb3b9f51624ae6f0095152661f2c4";

    /**
     * 获取用户token
     */
    @Test
    public void userToken() {
        // 创建请求对象
        UserTokenRequest request = new UserTokenRequest();
        UserTokenModel userTokenModel = new UserTokenModel();
        userTokenModel.setUserCode("59c0b071e78ab40ea4c79d2a58f6dda2");
        request.setBizModel(userTokenModel);
        // 发送请求
        CommonResponse response = client.execute(request);
        if (response.isSuccess()) {
            System.out.println("成功");
            // 返回结果
            String data = response.getData();
            System.out.println(data);

            UserTokenResponse userTokenResponse = response.getDataObj(UserTokenResponse.class);
            System.out.println(userTokenResponse.getUserAccessToken());
        } else {
            System.out.println("失败");
            System.out.println(response.getBody());
            System.out.println(response.getErrorMsg());
        }
    }


    /**
     * 店铺授权
     * 通过卖家标识，申请指定店铺的rpa运行权限。返回成功授权的店铺信息。该接口会删除原有授权，并将授权更新为当前状态，
     * 如，第一次调用授权接口入参为店铺A，第二次调用授权接口入参为店铺B，则最终授权店铺只有B。
     */
    @Test
    public void storeAuth() {
        System.out.println("=====StoreAuth start=====");
        RpaStoresAuthRequest request = new RpaStoresAuthRequest();
        List<RpaStoresAuthModel> models = new ArrayList<>();
        RpaStoresAuthModel model = new RpaStoresAuthModel();
        model.setRpaIdList(Arrays.asList(1576L, 1591L, 1598L));
        model.setSellerId("625782776");
        models.add(model);

        request.setBizModel(models);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("StoreAuth success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<List<RpaStoresAuthResponse>> wrapResponse = response.getRpaListObj(RpaStoresAuthResponse.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object:" + wrapResponse.getData());
        } else {
            System.out.println("StoreAuth failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====StoreAuth end=====");
    }

    /**
     * 新增店铺授权
     */
    @Test
    public void storeAuthAdd() {
        System.out.println("=====StoreAuthAdd start=====");
        RpaStoresAuthAddRequest request = new RpaStoresAuthAddRequest();
        List<RpaStoresAuthModel> models = new ArrayList<>();
        RpaStoresAuthModel model = new RpaStoresAuthModel();
        model.setRpaIdList(Arrays.asList(1576L, 1591L, 1598L));
        model.setSellerId("625782776");
        models.add(model);

        request.setBizModel(models);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("StoreAuthAdd success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<List<RpaStoresAuthResponse>> wrapResponse = response.getRpaListObj(RpaStoresAuthResponse.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object:" + wrapResponse.getData());
        } else {
            System.out.println("StoreAuthAdd failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====StoreAuthAdd end=====");
    }

    /**
     * 取消店铺授权
     */
    @Test
    public void storeAuthCancel() {
        System.out.println("=====StoreAuthCancel start=====");
        RpaStoresAuthCancelRequest request = new RpaStoresAuthCancelRequest();
        List<RpaStoresAuthModel> models = new ArrayList<>();
        RpaStoresAuthModel model = new RpaStoresAuthModel();
        model.setRpaIdList(Arrays.asList(1576L, 1591L, 1598L));
        model.setSellerId("625782776");
        models.add(model);

        request.setBizModel(models);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("StoreAuthCancel success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<String> wrapResponse = response.getRpaObj(String.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object:" + wrapResponse.getData());
        } else {
            System.out.println("StoreAuthCancel failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====StoreAuthCancel end=====");
    }


    /**
     * 查看计划详情
     */
    @Test
    public void planDetail() {
        System.out.println("=====PlanDetail start=====");
        RpaPlansGetRequest request = new RpaPlansGetRequest();
        RpaPlansGetModel model = new RpaPlansGetModel();
        //注意这里传计划ID参数
        model.setPlanId(137788L);
        request.setBizModel(model);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("PlanDetail success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<RpaPlansGetResponse> wrapResponse = response.getRpaObj(RpaPlansGetResponse.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object:" + wrapResponse.getData());
        } else {
            System.out.println("PlanDetail failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====PlanDetail end=====");
    }

    /**
     * 查询RPA详情
     */
    @Test
    public void rpaDetail() {
        System.out.println("=====RpaDetail start=====");
        RpaScriptsGetRequest request = new RpaScriptsGetRequest();
        RpaScriptsGetModel model = new RpaScriptsGetModel();
        //注意这里传RPAId,支持多个用逗号隔开，非必传
        model.setIds("1000,1002");
        request.setBizModel(model);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("RpaDetail success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<List<RpaScriptsGetResponse>> wrapResponse = response.getRpaListObj(RpaScriptsGetResponse.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object:" + wrapResponse.getData());
        } else {
            System.out.println("RpaDetail failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====RpaDetail end=====");
    }

    /**
     * 查询任务执行结果记录
     */
    @Test
    public void taskResultsReport() {
        System.out.println("=====TaskResultsReport start=====");
        RpaTasksResultsGetRequest request = new RpaTasksResultsGetRequest();
        RpaTasksResultsGetModel model = new RpaTasksResultsGetModel();
        model.setPageNum(1);
        model.setPageSize(10);
        model.setTaskId(1442287400042554L);
        request.setBizModel(model);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("TaskResultsReport success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<RpaTasksResultsGetResponse> wrapResponse = response.getRpaObj(RpaTasksResultsGetResponse.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object:" + wrapResponse.getData());
        } else {
            System.out.println("TaskResultsReport failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====TaskResultsReport end=====");
    }

    /**
     * 任务结果重试
     */
    @Test
    public void taskResultsReTry() {
        System.out.println("=====TaskResultsReTry start=====");
        RpaTasksResultsPutRequest request = new RpaTasksResultsPutRequest();
        RpaTasksResultsPutModel model = new RpaTasksResultsPutModel();
        //批量操作不超过5个，多个逗号分割,，通过tasks/results接口获取，对应字段为recoredId
        model.setResultIds("1442131176387839");
        // 非GET请求，Query参数 使用paramsModel
        request.setParamsModel(model);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("TaskResultsReTry success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<String> wrapResponse = response.getRpaObj(String.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object:" + wrapResponse.getData());
        } else {
            System.out.println("TaskResultsReTry failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====TaskResultsReTry end=====");
    }

    /**
     * 启用计划
     */
    @Test
    public void doStartPlan() {
        System.out.println("=====DoStartPlan start=====");
        RpaPlansDriversPostRequest request = new RpaPlansDriversPostRequest();
        RpaPlansDriversPostModel model = new RpaPlansDriversPostModel();
        // 多个逗号隔开，批量操作不能超过5个
        model.setPlanIds("5070,5167");
        // 非GET请求，Query参数 使用paramsModel
        request.setParamsModel(model);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("DoStartPlan success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<String> wrapResponse = response.getRpaObj(String.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object:" + wrapResponse.getData());
        } else {
            System.out.println("DoStartPlan failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====DoStartPlan end=====");
    }

    /**
     * 停用计划
     */
    @Test
    public void doStopPlan() {
        System.out.println("=====DoStopPlan start=====");
        RpaPlansDriversDelRequest request = new RpaPlansDriversDelRequest();
        RpaPlansDriversDelModel model = new RpaPlansDriversDelModel();
        // 多个逗号隔开，批量操作不能超过5个
        model.setPlanIds("5070,5167");
        // 非GET请求，Query参数 使用paramsModel
        request.setParamsModel(model);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("DoStopPlan success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<String> wrapResponse = response.getRpaObj(String.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object" + wrapResponse.getData());
        } else {
            System.out.println("DoStopPlan failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====DoStopPlan end=====");
    }

    /**
     * 查询任务执行记录
     */
    @Test
    public void listTask() {
        System.out.println("=====ListTask start=====");
        RpaTasksGetRequest request = new RpaTasksGetRequest();
        RpaTasksGetModel model = new RpaTasksGetModel();
        model.setPlanId(5070L);
        model.setPageNum(1);
        model.setPageSize(1);

        request.setBizModel(model);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("ListTask success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<RpaTasksGetResponse> wrapResponse = response.getRpaObj(RpaTasksGetResponse.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object:" + wrapResponse.getData());
        } else {
            System.out.println("ListTask failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====ListTask end=====");
    }

    /**
     * 修改计划
     */
    @Test
    public void replacementPlan() {
        System.out.println("=====ReplacementPlan start=====");
        RpaPlansReplacePostRequest request = new RpaPlansReplacePostRequest();
        RpaPlansReplacePostModel model = new RpaPlansReplacePostModel();

        model.setName("任务名称repeat");
        model.setPlatformId("0");
        model.setActionType("REPEAT_BY_WEEK");
        model.setRepeatRange("2,3");
        model.setRepeatTimeAt("00:01");
        // 添加rpa列表
        List<RpaPlansPostModel.ScriptDTO> scriptDTOS = new ArrayList<>();
        // 添加rpa任务参数列表
        List<RpaPlansPostModel.ScriptDTO.RunWithDTO> runWithDTOS = new ArrayList<>();
        RpaPlansPostModel.ScriptDTO.RunWithDTO runWithDTO = new RpaPlansPostModel.ScriptDTO
                .RunWithDTO("downloadTimeType", "last60");
        runWithDTOS.add(runWithDTO);

        RpaPlansPostModel.ScriptDTO scriptDto = new RpaPlansPostModel.ScriptDTO("1002", runWithDTOS);
        scriptDTOS.add(scriptDto);
        model.setScriptList(scriptDTOS);

        model.setStoreScopeType("ASSIGNED");
        // 添加店铺和站点
        List<RpaPlansPostModel.StoreAndMarketPlaceDTO> storeAndMarketPlaceDTOS = new ArrayList<>();
        RpaPlansPostModel.StoreAndMarketPlaceDTO storeAndMarketPlaceDto = new RpaPlansPostModel.
                StoreAndMarketPlaceDTO("16310663243655", "US,ES");
        storeAndMarketPlaceDTOS.add(storeAndMarketPlaceDto);
        model.setStoreAndMarketPlaceList(storeAndMarketPlaceDTOS);

        request.setBizModel(model);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("ReplacementPlan success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<RpaPlansReplacePostResponse> wrapResponse = response.getRpaObj(RpaPlansReplacePostResponse.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object:" + wrapResponse.getData());
        } else {
            System.out.println("ReplacementPlan failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====ReplacementPlan end=====");
    }

    /**
     * 创建任务
     */
    @Test
    public void createPlan() {
        System.out.println("=====CreatePlan start=====");
        RpaPlansPostRequest request = new RpaPlansPostRequest();
        RpaPlansPostModel model = new RpaPlansPostModel();

        model.setName("任务名称repeat");
        model.setPlatformId("0");
        model.setActionType("REPEAT_BY_WEEK");
        model.setRepeatRange("2,3");
        model.setRepeatTimeAt("00:01");
        // 添加rpa列表
        List<RpaPlansPostModel.ScriptDTO> scriptDTOS = new ArrayList<>();
        // 添加rpa任务参数列表
        List<RpaPlansPostModel.ScriptDTO.RunWithDTO> runWithDTOS = new ArrayList<>();
        RpaPlansPostModel.ScriptDTO.RunWithDTO runWithDTO = new RpaPlansPostModel.ScriptDTO
                .RunWithDTO("downloadTimeType", "last60");
        runWithDTOS.add(runWithDTO);

        RpaPlansPostModel.ScriptDTO scriptDto = new RpaPlansPostModel.ScriptDTO("1002", runWithDTOS);
        scriptDTOS.add(scriptDto);
        model.setScriptList(scriptDTOS);

        model.setStoreScopeType("ASSIGNED");
        // 添加店铺和站点
        List<RpaPlansPostModel.StoreAndMarketPlaceDTO> storeAndMarketPlaceDTOS = new ArrayList<>();
        RpaPlansPostModel.StoreAndMarketPlaceDTO storeAndMarketPlaceDto = new RpaPlansPostModel.
                StoreAndMarketPlaceDTO("16310663243655", "US,ES");
        storeAndMarketPlaceDTOS.add(storeAndMarketPlaceDto);
        model.setStoreAndMarketPlaceList(storeAndMarketPlaceDTOS);

        request.setBizModel(model);
        RpaResponse response = client.executeUserToken(request, userToken);
        if (response.isSuccess()) {
            System.out.println("CreatePlan success");
            // 返回结果
            String data = response.getData();
            System.out.println("response data:" + data);
            // 转为封装对象
            RpaBaseResponse<RpaPlansPostResponse> wrapResponse = response.getRpaObj(RpaPlansPostResponse.class);
            if (!wrapResponse.isSuccess()) {
                throw new RuntimeException(data);
            }
            System.out.println("response object:" + wrapResponse.getData());
        } else {
            System.out.println("CreatePlan failed");
            System.out.println("response body:" + response.getBody());
            throw new RuntimeException(response.getBody());
        }
        System.out.println("=====CreatePlan end=====");
    }

}

```