# sdk-java

sdk for java

[第三方应用接入文档](https://open.ziniao.com/docSupport?docId=84)

## bizModel和paramsModel使用场景
参数paramsModel用于设置url携带参数(GET请求以外有效)

- GET请求   使用bizModel           如：GET: /rpa/tasks/results

- POST、 PUT、DELETE请求：

    Body参数  使用bizModel         如：POST: /rpa/plans
    
    Query参数 使用paramsModel      如：POST: /rpa/plans/drivers, DELETE: /rpa/plans/drivers


## 接口封装步骤

比如查询计划详情接口

- 接口名：/rpa/plans
- 参数：planId 要查询的计划Id
- 返回信息
```
{
        "msg": "SUCCESS",
        "code": "0",
        "data": {
            "name": "任务名称repeat",
            "platformId": "0",
            "actionType": "REPEAT_BY_WEEK"
        },
        "requestId": "765656",
}
```

针对这个接口，封装步骤如下：

1.在`model`包下新建一个类，定义业务参数

```java
@Data
@ApiModel(value = "查询计划详情")
public class RpaPlansGetModel {

    @ApiModelProperty(value = "要查询的计划Id", example = "1001")
    private Long planId;
}
```

2.在`response`包下新建一个返回类, 里面填写返回的字段

```java
@Data
public  class RpaBaseResponse<T> {
    @JSONField(name = "code")
    public Integer code;

    @JSONField(name = "msg")
    public String msg;

    @JSONField(name = "requestId")
    public String requestId;

    @JSONField(name = "data")
    private T data;

    public boolean isSuccess() {
        return this.code == 0 && "SUCCESS".equals(this.msg);
    }
}

@Data
@ApiModel(value = "查看计划详情返回结果")
public class RpaPlansGetResponse {

    @ApiModelProperty(value = "执行类型)
    private String actionType;

    @ApiModelProperty(value = "指定运行时间")
    private String assignTime;

    @ApiModelProperty(value = "计划名称")
    private String name;
}
```

3.在`request`包下新建一个请求类，继承`BaseRequest`

BaseRequest中有个泛型参数，填`CommonResponse`类，表示这个请求对应的返回类。(RPA接口使用的`RpaResponse`继承了`CommonResponse`类)

重写`method()`方法，填接口名。

重写`getRequestMethod()`方法，填接口请求方式。

```java
public class RpaPlansGetRequest extends BaseRequest<RpaResponse> {
    @Override
    protected String method() {
        return "/rpa/plans";
    }

    @Override
    protected RequestMethod getRequestMethod() {
        return RequestMethod.GET;
    }
}


```

## 使用方式

```java
String url = "http://localhost:8081";
String appId = "2019032617262200001";
String privateKey = "你的私钥";

// 声明一个就行
OpenClient client = new OpenClient(url, appId, privateKey);

// 标准用法
@Test
public void testGet() {
    // 创建请求对象
    RpaPlansGetRequest request = new RpaPlansGetRequest();

    // 请求参数
    RpaPlansGetModel model = new RpaPlansGetModel();
    model.setPlanId(137788L);
    request.setBizModel(model);

    // 发送请求
    RpaResponse response = client.executeUserToken(request, "填写user_token");

    if (response.isSuccess()) {
        // 返回结果
        String data = response.getData();
        System.out.println("response data:" + data);
        // 转为封装对象
        RpaBaseResponse<RpaPlansGetResponse> wrapResponse = response.getRpaObj(RpaPlansGetResponse.class);
        if (!wrapResponse.isSuccess()) {
            throw new RuntimeException(data);
        }
    } else {
        System.out.println(response);
    }
}
```


```java
    public static class UserOpenIdRequest extends BaseRequest<CommonResponse> {
        @Override
        protected String method() {
            return "/user/get_open_id"; // 填写开放平台上文档的接口地址
        }

        @Override
        protected RequestMethod getRequestMethod() {
            return RequestMethod.POST_JSON; // 按接口请求方式填写
        }
    }

    @Test
    public void testGetUserOpenId() {
        // 创建请求方式一，声明创建的请求类
        UserOpenIdRequest request = new UserOpenIdRequest();
        // 创建请求方式二，通过CommonRequest构造方法设置
//        CommonRequest request = new CommonRequest("/user/get_open_id", RequestMethod.POST_FORM);
        // 按接口要求设置业务参数
        // 设置业务参数 方式一，放到Map
        // Map<String, Object> bizContent = new HashMap<>();
        // bizContent.put("userCode", "2d42cd893719d64faa768974774e4eb9");
        // request.setBizContent(JSON.toJSONString(bizContent));
        // 设置业务参数 方式二，创建对象
        // UserTokenModel userTokenModel = new UserTokenModel();
        // userTokenModel.setUserCode("2d42cd893719d64faa768974774e4eb9");
        // request.setBizModel(userTokenModel);
        // 发送请求
        String userToken = "fd39e1e21f957b9bfc44410c486d9ea0";
        CommonResponse response = client.executeUserToken(request, userToken);
        // 根据接口要求传入user_token或app_token
        //CommonResponse response = client.executeUserToken(request, "userToken");
        //CommonResponse response = client.executeAppToken(request, "appToken");
        if (response.isSuccess()) {
            System.out.println("成功");
            // 返回结果
            String data = response.getData();
            System.out.println(data);
        } else {
            System.out.println("失败");
            System.out.println(response.getBody());
            System.out.println(response.getErrorMsg());
        }
    }
```