/*
 * Decompiled with CFR 0.152.
 */
package com.fzzixun.openapi.sdk.request;

import com.alibaba.fastjson.JSON;
import com.fzzixun.openapi.sdk.common.OpenConfig;
import com.fzzixun.openapi.sdk.common.RequestForm;
import com.fzzixun.openapi.sdk.common.RequestMethod;
import com.fzzixun.openapi.sdk.common.UploadFile;
import com.fzzixun.openapi.sdk.response.BaseResponse;
import com.fzzixun.openapi.sdk.util.ClassUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.MediaType;

public abstract class BaseRequest<T extends BaseResponse> {
    private static final String EMPTY_JSON = "{}";
    private String method;
    private String version;
    private String sdkVersion;
    private String bizContent = "{}";
    private Object bizModel;
    private RequestMethod requestMethod = RequestMethod.POST_JSON;
    private MediaType mediaType;
    private String paramsContent = "{}";
    private Object paramsModel;
    private List<UploadFile> files;
    private Class<T> responseClass = ClassUtil.getSuperClassGenricType(this.getClass(), 0);

    protected abstract String method();

    public BaseRequest() {
        this.method = this.method();
        this.version = this.version();
        this.sdkVersion = this.sdkVersion();
    }

    protected BaseRequest(String method, String version) {
        this.method = method;
        this.version = version;
    }

    protected String version() {
        return this.version;
    }

    protected String sdkVersion() {
        return this.sdkVersion;
    }

    public void addFile(UploadFile file) {
        if (this.files == null) {
            this.files = new ArrayList<UploadFile>();
        }
        this.files.add(file);
    }

    public RequestForm createRequestForm(OpenConfig openConfig) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put(openConfig.getMethodName(), this.method);
        params.put(openConfig.getFormatName(), openConfig.getFormatType());
        params.put(openConfig.getCharsetName(), openConfig.getCharset());
        params.put(openConfig.getSignTypeName(), openConfig.getSignType());
        long timestamp = Instant.now().toEpochMilli();
        params.put(openConfig.getTimestampName(), String.valueOf(timestamp));
        String v = this.version == null ? openConfig.getDefaultVersion() : this.version;
        params.put(openConfig.getVersionName(), v);
        String sV = this.sdkVersion == null ? openConfig.getDefaultSdkVersion() : this.sdkVersion;
        params.put(openConfig.getSdkVersionName(), sV);
        String biz_content = this.buildBizContent();
        params.put(openConfig.getDataName(), biz_content);
        String urlParams = this.buildParamsContent();
        params.put(openConfig.getParamsDataName(), urlParams);
        RequestForm requestForm = new RequestForm(params);
        requestForm.setRequestMethod(this.getRequestMethod());
        requestForm.setCharset(openConfig.getCharset());
        requestForm.setFiles(this.files);
        return requestForm;
    }

    protected String buildBizContent() {
        if (this.bizModel != null) {
            return JSON.toJSONString((Object)this.bizModel);
        }
        return this.bizContent;
    }

    protected String buildParamsContent() {
        if (this.paramsModel != null) {
            return JSON.toJSONString((Object)this.paramsModel);
        }
        return this.paramsContent;
    }

    public String getMethod() {
        return this.method;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public void setBizContent(String bizContent) {
        this.bizContent = bizContent;
    }

    public void setBizModel(Object bizModel) {
        this.bizModel = bizModel;
    }

    public void setFiles(List<UploadFile> files) {
        this.files = files;
    }

    public Class<T> getResponseClass() {
        return this.responseClass;
    }

    public void setParamsContent(String paramsContent) {
        this.paramsContent = paramsContent;
    }

    public void setParamsModel(Object paramsModel) {
        this.paramsModel = paramsModel;
    }

    protected RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }
}

